// Topic 6: Function overriding and virtual functions (polymorphism)

#include <stdio.h>

class Base
{
	public:
		// THIS FUNCTION IS NOW VIRTUAL
		virtual void Foo() { printf("BASE!\n"); }

	protected:
};

class Child : public Base
{
	public:
		Child() { m_value = 50; }

		virtual void Foo() { printf("CHILD!\n"); }

		void Bar() { printf("Value: %d\n", m_value); }

	private:
		int m_value;
};

void main()
{
	Base* pBase1 = new Base;
	Base* pBase2 = new Child;

	pBase1->Foo();	// Will run Base version
	pBase2->Foo();	// Will NOW run Child version because Foo is virtual
					// *** pBase2 polymorphed from Base to Child automatically!

	// Clean up
	delete pBase1;
	delete pBase2;
}